@extends('layouts.master')

@section('title')
    تقرير الحضور والغياب
@endsection

@section('first-css')
<link href="{{asset('/css/report.css')}}" rel="stylesheet">
@endsection

@section('content-body')
    <!--**********************************
                            Content body start
                        ***********************************-->
    @include('massages')
@section('route-path')
    <div class="container-fluid container-fluid-traning px-0">
        <div class="d-flex flex-wrap align-items-end justify-content-between  mb-3">
            <h1>
                تقرير الحضور والغياب
            </h1>
            <div class="link">
                <a href="" class="px-4 ">عرض تقرير الحضور والغياب
                </a>
            </div>
        </div>
    </div>
@endsection
<!-- row -->
<div class="container-fluid container-fluid-traning bg-white">
    <!--**********************************Tabs Start***********************************-->
    <div class="d-flex flex-wrap align-items-start justify-content-start  mb-3 btns">
        <button type="button" class="btn btn-primary  me-1" data-bs-toggle="modal" data-bs-target="#addEvaluation">
            <i class="mdi mdi-plus-circle ms-2"></i> تصدير
        </button>
        <button  id="printCertificate"  type="button" class="btn btn-secondary  me-1"  >
            <i class="mdi mdi-print-circle ms-2"></i>طباعة
        </button>
    </div>
    <!--**********************************Tabs End***********************************-->
    <div class="row">
        <div class="col-xl-12 tab-content">
            <!--**********************************Table AllTransaction Start***********************************-->

            <div class="tab-pane fade show active" id="AllTransaction" role="tabpanel"
                aria-labelledby="transaction-tab">
                <div class="table-responsive fs-14">
                    <table class="table card-table display mb-4 dataTablesCard text-black text-center" id="example">
                        <thead>
                            <tr>
                                <th>رقم </th>
                                <th>البرنامج </th>
                                <th>عدد الطلاب</th>
                                <th>نسبة الحضور</th>
                                <th>نسبة الغياب</th>
                                <th>نسبة الدروس الغير منجزة</th>

                            </tr>
                        </thead>
                        <tbody>
                            @isset($rooms)
                                @foreach ($rooms as $room)
                                    <tr class="odd" role="row">
                                        <td>
                                            @isset($room)
                                                {{ $loop->iteration }}
                                            @endisset
                                        </td>
                                        <td>
                                            <a href="{{route('report_attendances_students',$room->id)}}">
                                            @isset($room->name)
                                                {{ $room->name }}
                                                {{ $room->course->title }}
                                            @endisset
                                            </a>
                                        </td>

                                        <td>
                                            @isset($room->studentsCount)
                                                {{ $room->studentsCount }}
                                            @endisset
                                        </td>

                                        <td>
                                            @isset($room->presentsPercentage)
                                                {{ $room->presentsPercentage }}
                                            @else
                                                0
                                            @endisset
                                                %
                                        </td>
                                        <td>
                                            @isset($room->absentsPercentage)
                                                {{ $room->absentsPercentage }}
                                            @else
                                                0
                                            @endisset
                                                %
                                        </td>
                                        <td>
                                            @isset($room->notAttendantPercentage)
                                                {{ $room->notAttendantPercentage }}
                                            @else
                                                0
                                            @endisset
                                                %
                                        </td>

                                    </tr>
                                @endforeach
                            @endisset
                            
                        </tbody>
                    </table>
                </div>
            </div>
            <!--**********************************Table AllTransaction End***********************************-->
        </div>
    </div>
</div>

<!--**********************************
                        Content body end
            ***********************************-->
<script src="{{asset('js/print/report.js')}}"></script>
@endsection
@section('script')
@endsection
